<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BlogPost extends Model 
{

    protected $table = 'blog_posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'sub_title', 'content');

    public function blog()
    {
        return $this->belongsTo('App\Classes\Blog');
    }

    public function rejection()
    {
        return $this->hasOne('App\Classes\Reject');
    }

}